<#ibiztemplate>
TARGET=PSDELOGIC
</#ibiztemplate>
package ${pub.getPKGCodeName()}.${de.getPSSystemModule().codeName?lower_case}.logic.impl;

import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import ${pub.getPKGCodeName()}.${de.getPSSystemModule().codeName?lower_case}.mapper.${de.codeName}Mapper;
import ${pub.getPKGCodeName()}.${de.getPSSystemModule().codeName?lower_case}.domain.${de.codeName};
import ${pub.getPKGCodeName()}.${de.getPSSystemModule().codeName?lower_case}.service.${de.codeName}Service;
import ${pub.getPKGCodeName()}.ibizutil.service.ServiceImplBase;
import ${pub.getPKGCodeName()}.${de.getPSSystemModule().codeName?lower_case}.service.dto.${de.codeName}SearchFilter;
import org.springframework.util.DigestUtils;
import org.springframework.util.StringUtils;
import java.util.UUID;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.math.BigInteger;
import ${pub.getPKGCodeName()}.ibizutil.annotation.PreField;
import java.lang.reflect.Field;
import org.kie.api.runtime.KieSession;
import ${pub.getPKGCodeName()}.${de.getPSSystemModule().codeName?lower_case}.logic.${de.codeName}Logic;
import java.util.HashMap;
import org.kie.api.runtime.KieContainer;
import ${pub.getPKGCodeName()}.ibizutil.errors.BadRequestAlertException;
import org.aspectj.lang.annotation.Aspect;
/**
 * 实体[${de.codeName}] 处理逻辑接口实现
 */
@Service
public class ${de.codeName}LogicImpl  implements  ${de.codeName}Logic{

<#if de.getAllPSDEActions()??>
    <#assign outputDELogic=false>
    <#list de.getAllPSDEActions() as DEAction>
        <#if DEAction.getPSDEActionLogics()??>
            <#assign outputDELogic=true>
            <#list DEAction.getPSDEActionLogics() as ActionLogic><#comment>实体行为附加逻辑</#comment>
                <#if ActionLogic.isInternalLogic()==true><#comment>内部逻辑</#comment>
                    <#assign DELogic=ActionLogic.getPSDELogic()>
                    <#assign ExecutePoint=ActionLogic.getAttachMode()?lower_case?cap_first>
                    <#assign ExecuteDEAction=ActionLogic.getPSDEAction()>
    <#comment>由于附加逻辑需要按照次序执行，而Aspect的order只能注解在类上，所以只能发内部类实现此需求</#comment>
    <#assign orderIndex=ActionLogic_index?c><#comment>Before中order越小越先执行，After中order越大越先执行</#comment>
    <#if ExecutePoint=='After' && orderIndex!='0'>
        <#assign orderIndex="-"+orderIndex>
    </#if>
    @Aspect
    @org.springframework.core.annotation.Order(${orderIndex})
    @Service
    class ${de.codeName?lower_case?cap_first}Execute${DELogic.codeName?lower_case?cap_first}${ExecutePoint}${ExecuteDEAction.codeName?lower_case?cap_first}{
         @org.aspectj.lang.annotation.${ExecutePoint}(value = "execution(* ${pub.getPKGCodeName()}.*.service.${de.codeName}Service.${srfmethodname(ExecuteDEAction.codeName)}(..))")
          void execute(org.aspectj.lang.JoinPoint point) throws Exception {
             ${de.codeName}LogicImpl.this.ExecuteDELogic(point,"${srfmethodname(DELogic.getCodeName())}");
        }
    }
                </#if>
            </#list>
        </#if>
    </#list>
    <#if outputDELogic==true>
    /**
     * 执行处理逻辑
     * @param point
     * @param LogicName
     * @throws Exception
     */
    public void ExecuteDELogic(org.aspectj.lang.JoinPoint point,String LogicName) throws Exception {
        Object [] args = point.getArgs();
        Object obj =args[0];
        if (obj instanceof ${de.codeName}){
            ${de.codeName} entity = (${de.codeName}) obj;
            java.lang.reflect.Method method = this.getClass().getMethod(LogicName,${de.codeName}.class);
            method.invoke(this,entity);
        }
    }
    </#if>
</#if>

    @Autowired
    private KieContainer kieContainer;

<#if de.getAllPSDELogics()??>
    <#list de.getAllPSDELogics() as delogic>
        <#comment>注入处理逻辑中所用到的service对象</#comment>
        <#if delogic.getPSDELogicNodes?? && delogic.getPSDELogicNodes()??>
            <#list delogic.getPSDELogicNodes() as deLogicNode>
                <#if deLogicNode.getDstPSDataEntity?? && deLogicNode.getDstPSDataEntity()??>
                    <#assign nodePSDataEntity=deLogicNode.getDstPSDataEntity()>
                    <#if !P.exists("Autowired",nodePSDataEntity.getCodeName(),"service")>
    @Autowired
    private ${pub.getPKGCodeName()}.${nodePSDataEntity.getPSSystemModule().codeName?lower_case}.service.${nodePSDataEntity.codeName}Service ${deLogicNode.getDstPSDataEntity().getCodeName()?lower_case}service;
                    </#if>
                </#if>
            </#list>
        </#if>
    </#list>
    <#comment>注入当前实体的service对象，供自定义查询使用</#comment>
    @Autowired
    private ${pub.getPKGCodeName()}.${de.getPSSystemModule().codeName?lower_case}.service.${de.codeName}Service iBzSysDefaultService;
</#if>

<#if de.getAllPSDELogics()??>
    <#list de.getAllPSDELogics() as delogic>
        <#assign logicName=(de.codeName+delogic.codeName)?lower_case>
	public boolean ${srfmethodname(delogic.getCodeName())}(${de.codeName} et){
           KieSession kieSession = null;
        try{
           kieSession=kieContainer.newKieSession();
        <#comment>插入逻辑参数</#comment>
        <#if delogic.getPSDELogicParams?? && delogic.getPSDELogicParams()??>
            <#list delogic.getPSDELogicParams() as logicParam>
                <#assign paramObj=(logicName+logicParam.codeName)?lower_case>
                <#assign paramObjValue=(logicName+logicParam.codeName)?lower_case>
                <#if logicParam.isDefault()==true><#comment>默认变量</#comment>
                    <#assign paramObjValue="et">
                <#elseif logicParam.getParamPSDataEntity?? && logicParam.getParamPSDataEntity()??>
                    <#assign ParamPSDataEntity=logicParam.getParamPSDataEntity()>
           ${pub.getPKGCodeName()}.${de.getPSSystemModule().codeName?lower_case}.domain.${ParamPSDataEntity.codeName}  ${(logicName+logicParam.codeName)?lower_case} =new ${pub.getPKGCodeName()}.${de.getPSSystemModule().codeName?lower_case}.domain.${ParamPSDataEntity.codeName}();
                <#else>
           Map ${(logicName+logicParam.codeName)?lower_case} =new HashMap();
                </#if>
           kieSession.insert(${paramObjValue}); <#comment>将逻辑参数存储到fact中</#comment>
           kieSession.setGlobal("${paramObj}",${paramObjValue});<#comment>将逻辑参数存储到global中</#comment>
            </#list>
        </#if>
        <#comment>插入处理逻辑中所用到的service对象</#comment>
        <#if delogic.getPSDELogicNodes?? && delogic.getPSDELogicNodes()??>
            <#list delogic.getPSDELogicNodes() as deLogicNode>
                <#if deLogicNode.getDstPSDataEntity?? && deLogicNode.getDstPSDataEntity()??>
                    <#if !P.exists(delogic.codeName,"kieSessionGlobalService",deLogicNode.getDstPSDataEntity().getCodeName()?lower_case)>
           kieSession.setGlobal("${deLogicNode.getDstPSDataEntity().getCodeName()?lower_case}service",${deLogicNode.getDstPSDataEntity().getCodeName()?lower_case}service);<#comment>将逻辑中引用到的service存储到global中</#comment>
                    </#if>
                </#if>
            </#list>
        </#if>
        <#comment>插入当前实体的defaultService对象，供自定义查询使用</#comment>
           kieSession.setGlobal("iBzSys${de.codeName?lower_case?cap_first}DefaultService",iBzSysDefaultService);<#comment>将逻辑中引用到的service存储到global中</#comment>
           kieSession.startProcess("${pub.getPKGCodeName()}.${de.getPSSystemModule().codeName?lower_case}.logic.${de.codeName?lower_case}logic.${delogic.getCodeName()?lower_case}");<#comment>执行所要执行的流程</#comment>

        }catch(Exception e){
            throw new BadRequestAlertException("执行[${delogic.getName()}]处理逻辑发生异常"+e,"","");
        }finally {
            if(kieSession!=null)
            kieSession.destroy();
        }
            return true;
    }
    </#list>
</#if>

}